<?php

/*
 * @copyright   2016 Mautic Contributors. All rights reserved
 * @author      Mautic
 *
 * @link        http://mautic.org
 *
 * @license     GNU/GPLv3 http://www.gnu.org/licenses/gpl-3.0.html
 */

namespace Mautic\Migrations;

use Doctrine\DBAL\Migrations\SkipMigrationException;
use Doctrine\DBAL\Schema\Schema;
use Mautic\CoreBundle\Doctrine\AbstractMauticMigration;

/**
 * Class Version20160728000000.
 */
class Version20160728000000 extends AbstractMauticMigration
{
    public function preUp(Schema $schema)
    {
        if ($schema->getTable($this->prefix.'campaign_lead_event_log')->hasColumn('channel')) {
            throw new SkipMigrationException('Schema includes this migration');
        }
    }

    /**
     * @param Schema $schema
     */
    public function up(Schema $schema)
    {
        $this->addSql("ALTER TABLE {$this->prefix}campaign_lead_event_log ADD channel VARCHAR(255) DEFAULT NULL, ADD channel_id INT DEFAULT NULL;");
    }
}
